#pragma once
#include "Config.h"
#include "afxtempl.h"
#include "SMSCodec.h"
#include "FileDB.h"
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
#define kSmsMsgMaxSize					kSMS_Data_MaxSize_Default
//
#define kSmsFirstIndex					1
#define kSmsSection						"SMS"
/******************/
//Keys
/******************/
#define kSmsMem1Key						"Mem1"
#define kSmsMem2Key						"Mem2"
#define kSmsMem3Key						"Mem3"
#define kSmsMaxMem1StorageKey			"MaxMem1"
#define kSmsMaxMem2StorageKey			"MaxMem2"
#define kSmsMaxMem3StorageKey			"MaxMem3"
#define kSmsCenterNumberKey				"CenterNumber"
#define kSmsIndicModeKey				"IndicMode"
#define kSmsMtModeKey					"MtMode"
#define kSmsBmModeKey					"BmMode"
#define kSmsDsModeKey					"DsMode"
#define kSmsBfrModeKey					"BfrMode"
#define kSmsBfrSizeKey					"BfrSize"
#define kSmsSmsFormatKey				"SmsFormat"
#define kSmsCenterNumberTypeKey			"CenterNumberType"
#define kSmsMOSmsServiceKey				"MOService"
#define kSmsSubmitIDKey					"SubmitID"
#define kSmsRefNumberKey				"SmsRefNumber"
/******************/
//Default values
/******************/
//SMS Storage
#define kDefMemoryLocation				kMemoryLocationSM
#define kDefMaxSmsStorage					20
//Unsolicited result
#define kDefIndicationMode				kFIFOBufferMode
#define kDefMtMode						kNoSMSDELIVERroutedToTE
#define kDefBmMode						kNoCBMIndRiutedToTE
#define kDefDsMode						kNoSTATUSREPORTroutedToTE
#define kDefBfrMode						kFlushBuffer
//Bfr
#define kDefBfrSize						5
//SMS Format
#define kDefSMSFormat					kPDUFormat
//sms Center number
#define kDefSmsCenterNumber				"+336534985"
#define kDefCenterNumberType			145
//MO SMS service
#define kDefMOSMSService				1
//SubmitID
#define kDefSubmitID					0
//Memory management
#define kSmsDefMem1Loaction				kMemoryLocationSM
#define kSmsDefMem2Loaction				kMemoryLocationSM
#define kSmsDefMem3Loaction				kMemoryLocationSM
// Sms reference number
#define kSmsDefRefNumber				1
/******************/
//possible values
/******************/
//SMS Storage
#define	kMemoryLocationBM				"BM"
#define	kMemoryLocationME				"ME"
#define	kMemoryLocationMT				"MT"
#define	kMemoryLocationSM				"SM"
#define	kMemoryLocationTA				"TA"
#define	kMemoryLocationSR				"SR"

//Unsolicited result code
#define kFIFOBufferMode					0
#define kForwardResltToTE				1
#define kBufferedIfLinkReserved			2
#define kForwardToTEOnSpecificInband	3

#define kNoSMSDELIVERroutedToTE			0
#define kSMSDELIVERstoredRoutedToTE		1
#define kSMSDELIVERroutedToTE			2
#define kClass3SMSDELIVERroutedToTE		3

#define kNoCBMIndRiutedToTE				0
#define kCBMStoredRoutedToTe			1
#define kNewCBMroutedToTE				2
#define	kClass3CBMroutedToTE			3

#define kNoSTATUSREPORTroutedToTE		0
#define kSTATUSREPORTroutedToTE			1
#define kSTAUSREPORTstoredRouteToTE		2

#define kFlushBuffer					0
#define kClearBuffer					1
//SMS Format
#define kPDUFormat						0
#define kTextFormat						1

/////////////////////////////////////////////////////////////////////////////
//SMS file storage
#define kSmsMsgStateKey					"State"
#define	kSmsMsgDirectionKey				"Dir"
#define	kSmsMsgTypeIndicatorKey			"Type"
#define	kSmsMsgCenterInMSKey			"SMSC"
#define kSmsMsgCenterTON				"SMSCTON"
#define	kSmsReportKey					"Report"
#define	kSmsPartCountKey				"PCount"
#define	kSmsPartCurrentKey				"PCurr"
#define kSmsPartIdKey					"PId"
#define kSmsSubmitIdKey					"SubId"
#define kSmsPDUKey						"PDU"
#define kSmsDataKey						"Data"
/////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif
///////////////////////////////////////////////////////////////////////////////
class CSMSParams;
typedef enum
	{
	received_unread=0,
	received_read,
	stored_unsent,
	stored_sent,
	all,
	};
///////////////////////////////////////////////////////////////////////////////
class CSMS
{
public:
	CSMSParams*		paramP;
	CCharSetString* pduP;
	//
	UInt8	 		stat;
	UInt8	 		msgTypeIndicator;		/* Status-Report, ... */
	UInt16	 		index;					/* SMS index on the phone storage */
	UInt16	 		partCount;				/* CDMA & GSM & TDMA(?) */
	UInt16	 		partCurrent;			/* CDMA & GSM & TDMA(?) */
	UInt16	 		partId;					/* CDMA & GSM & TDMA(?) */
	CString* 		stringP;
	Bool	 		report;					/* Delivery request / indicator */
	UInt32	 		msgId;
public:
	CSMS()
		{
		stringP = new CString();
		paramP = new CSMSParams();
        pduP = new CCharSetString();
		stat = msgTypeIndicator = (UInt8)-1;
		index = (UInt16)-1;
		partCount = partCurrent = partId = 0;
		report = 0;
		msgId = (UInt32)-1;
		};
	virtual ~CSMS()
		{
		resetPtr(stringP);
		resetPtr(paramP);
		resetPtr(pduP);
		};
};
///////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CConfigSMS : public CConfig
{
public:
	CConfigSMS() {};
	CConfigSMS(CDllManager* iDllManager);
	virtual ~CConfigSMS(void);
	/*Common Config interface*/
	virtual Bool	Save();
	virtual Bool	Load();
	/*Accessors*/
	virtual int		StoreSms(CSMS *iSmsP, int iIndex=-1);	
	virtual Bool	StoreSentSms(CSMS *iSmsP);	
	virtual UINT 	GetStoredSms(CSMS *opSMSP, UInt16 iMsgIndex, Bool iProcessPDU=false);
	virtual UINT 	GetStoredSentSms(CSMS *opSMSP, UInt16 iMsgIndex, Bool iProcessPDU=false);
	virtual UINT 	GetMaxIndexInStoredSms();
	virtual UINT 	GetMaxIndexInStoredSentSms();
	virtual UINT 	GetNbEntries();
	virtual Bool 	DeleteStoredSms(UInt16 iSmsIndex);
	virtual Bool 	DeleteStoredSentSms(UInt16 iSmsIndex);
	virtual UInt16	GetMaxSmsSize();
	virtual void 	SetMem1(CString iMem1, UINT iMaxEntries=(UINT)-1);
	virtual void 	SetMem2(CString iMem2, UINT iMaxEntries=(UINT)-1);
	virtual void 	SetMem3(CString iMem3, UINT iMaxEntries=(UINT)-1);
	virtual UINT 	GetMem1(CString* iMem1);
	virtual UINT 	GetMem2(CString* iMem2);
	virtual UINT 	GetMem3(CString* iMem3);
	virtual UINT 	GetNewSubmitID();
	virtual void 	SetIndicationMode(UInt8 iIndicationMode);
	virtual void 	SetMtMode(UInt8 iMtMode);
	virtual void 	SetBmMode(UInt8 iBmMode);
	virtual void 	SetDsMode(UInt8 mDsMode);
	virtual void 	SetBfrMode(UInt8 mBfrMode);
	virtual UInt8 	GetIndicationMode();
	virtual UInt8 	GetMtMode();
	virtual UInt8 	GetBmMode();
	virtual UInt8 	GetDsMode();
	virtual UInt8 	GetBfrMode();
	virtual void	PrvAddNotif(CString iNotif, int iSmsClass=-1);
	virtual void	FlushBfrToTE();
	virtual void	ClearBfr();
	virtual UInt8	GetSMSFormat();
	virtual void	SetSMSFormat(UInt8 iFormat);
	virtual CString	GetSmsCenterNumber();
	virtual void	SetSmsCenterNumber(CString iNumber);
	virtual void	SetSmsCenterNumberType(UInt8 iType);
	virtual UInt8	GetSmsCenterNumberType();
	virtual UInt8	GetMOSMSservice();
	virtual void	SetMOSMSservice(UInt8 iService);
	virtual void	SetMaxSmsStorage(UInt16 iMaxSmsStorage);
	virtual UInt16	GetMaxSmsStorage();
	virtual void	SendNotifSMSReceived(int iIndex, CString iStorage);
	virtual int		GetSmsReferenceNumber();
	virtual void	SetSmsReferenceNumber(int iRefNumber);

protected:
	CString			mMem1, mMem2, mMem3;
	UINT			mMaxEntriesMem1, mMaxEntriesMem2,	mMaxEntriesMem3;
	UINT			mMaxSmsStorage;
	CFileDB*		mSmsStorageFile;
	CFileDB*		mSentSmsStorageFile;
	UINT			mSubmitID;
	UInt8			mIndicationMode, mMtMode, mBmMode, mDsMode, mBfrMode;
	CList<CString, CString&> mBfr;
	UINT			mBfrSize;
	UInt8			mSmsFormat;
	CString			mSmsCenterNumber;
	UInt8			mCenterNumberType;
	UInt8			mMOSMSservice;
	UInt16			mSmsRefNumber;
	virtual Bool	PrvStoreSms(CFileDB* iDbFile, char* iIndexStr, CSMS *iSmsP);	
	virtual void	PrvFlushBfrToTE();
	virtual void	PrvClearBfr();	
};
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
